(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     38116,       1183]*)
(*NotebookOutlinePosition[     38960,       1210]*)
(*  CellTagsIndexPosition[     38916,       1206]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 6.4  .2\ \  : \ To\ compute\ e_Q\  = \ \(intx\  - \ int\n
        \tor\ \ e_Q\  = \ int\  - \ intx\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(g[s_] := \ x*s*Cos[s]; \nFindRoot[Cos[s] == s*Sin[s], \ {s, 1}]\), 
    \(Plot[s*Cos[s], \ {s, \ 0, \ \[Pi]}]\)}], "Input"],

Cell[BoxData[
    \({s \[Rule] 0.860333589028837764`}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.303152 0.514123 0.158967 [
[.17539 .50162 -9 -9 ]
[.17539 .50162 9 0 ]
[.32696 .50162 -3 -9 ]
[.32696 .50162 3 0 ]
[.47854 .50162 -9 -9 ]
[.47854 .50162 9 0 ]
[.63011 .50162 -3 -9 ]
[.63011 .50162 3 0 ]
[.78169 .50162 -9 -9 ]
[.78169 .50162 9 0 ]
[.93327 .50162 -3 -9 ]
[.93327 .50162 3 0 ]
[.01131 .03722 -12 -4.5 ]
[.01131 .03722 0 4.5 ]
[.01131 .11671 -24 -4.5 ]
[.01131 .11671 0 4.5 ]
[.01131 .19619 -12 -4.5 ]
[.01131 .19619 0 4.5 ]
[.01131 .27567 -24 -4.5 ]
[.01131 .27567 0 4.5 ]
[.01131 .35516 -12 -4.5 ]
[.01131 .35516 0 4.5 ]
[.01131 .43464 -24 -4.5 ]
[.01131 .43464 0 4.5 ]
[.01131 .59361 -18 -4.5 ]
[.01131 .59361 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .51412 m
.17539 .52037 L
s
[(0.5)] .17539 .50162 0 1 Mshowa
.32696 .51412 m
.32696 .52037 L
s
[(1)] .32696 .50162 0 1 Mshowa
.47854 .51412 m
.47854 .52037 L
s
[(1.5)] .47854 .50162 0 1 Mshowa
.63011 .51412 m
.63011 .52037 L
s
[(2)] .63011 .50162 0 1 Mshowa
.78169 .51412 m
.78169 .52037 L
s
[(2.5)] .78169 .50162 0 1 Mshowa
.93327 .51412 m
.93327 .52037 L
s
[(3)] .93327 .50162 0 1 Mshowa
.125 Mabswid
.05412 .51412 m
.05412 .51787 L
s
.08444 .51412 m
.08444 .51787 L
s
.11476 .51412 m
.11476 .51787 L
s
.14507 .51412 m
.14507 .51787 L
s
.2057 .51412 m
.2057 .51787 L
s
.23602 .51412 m
.23602 .51787 L
s
.26633 .51412 m
.26633 .51787 L
s
.29665 .51412 m
.29665 .51787 L
s
.35728 .51412 m
.35728 .51787 L
s
.38759 .51412 m
.38759 .51787 L
s
.41791 .51412 m
.41791 .51787 L
s
.44822 .51412 m
.44822 .51787 L
s
.50885 .51412 m
.50885 .51787 L
s
.53917 .51412 m
.53917 .51787 L
s
.56948 .51412 m
.56948 .51787 L
s
.5998 .51412 m
.5998 .51787 L
s
.66043 .51412 m
.66043 .51787 L
s
.69074 .51412 m
.69074 .51787 L
s
.72106 .51412 m
.72106 .51787 L
s
.75138 .51412 m
.75138 .51787 L
s
.81201 .51412 m
.81201 .51787 L
s
.84232 .51412 m
.84232 .51787 L
s
.87264 .51412 m
.87264 .51787 L
s
.90295 .51412 m
.90295 .51787 L
s
.96358 .51412 m
.96358 .51787 L
s
.9939 .51412 m
.9939 .51787 L
s
.25 Mabswid
0 .51412 m
1 .51412 L
s
.02381 .03722 m
.03006 .03722 L
s
[(-3)] .01131 .03722 1 0 Mshowa
.02381 .11671 m
.03006 .11671 L
s
[(-2.5)] .01131 .11671 1 0 Mshowa
.02381 .19619 m
.03006 .19619 L
s
[(-2)] .01131 .19619 1 0 Mshowa
.02381 .27567 m
.03006 .27567 L
s
[(-1.5)] .01131 .27567 1 0 Mshowa
.02381 .35516 m
.03006 .35516 L
s
[(-1)] .01131 .35516 1 0 Mshowa
.02381 .43464 m
.03006 .43464 L
s
[(-0.5)] .01131 .43464 1 0 Mshowa
.02381 .59361 m
.03006 .59361 L
s
[(0.5)] .01131 .59361 1 0 Mshowa
.125 Mabswid
.02381 .05312 m
.02756 .05312 L
s
.02381 .06902 m
.02756 .06902 L
s
.02381 .08491 m
.02756 .08491 L
s
.02381 .10081 m
.02756 .10081 L
s
.02381 .1326 m
.02756 .1326 L
s
.02381 .1485 m
.02756 .1485 L
s
.02381 .1644 m
.02756 .1644 L
s
.02381 .18029 m
.02756 .18029 L
s
.02381 .21209 m
.02756 .21209 L
s
.02381 .22798 m
.02756 .22798 L
s
.02381 .24388 m
.02756 .24388 L
s
.02381 .25978 m
.02756 .25978 L
s
.02381 .29157 m
.02756 .29157 L
s
.02381 .30747 m
.02756 .30747 L
s
.02381 .32336 m
.02756 .32336 L
s
.02381 .33926 m
.02756 .33926 L
s
.02381 .37105 m
.02756 .37105 L
s
.02381 .38695 m
.02756 .38695 L
s
.02381 .40285 m
.02756 .40285 L
s
.02381 .41874 m
.02756 .41874 L
s
.02381 .45054 m
.02756 .45054 L
s
.02381 .46643 m
.02756 .46643 L
s
.02381 .48233 m
.02756 .48233 L
s
.02381 .49823 m
.02756 .49823 L
s
.02381 .53002 m
.02756 .53002 L
s
.02381 .54592 m
.02756 .54592 L
s
.02381 .56181 m
.02756 .56181 L
s
.02381 .57771 m
.02756 .57771 L
s
.02381 .02133 m
.02756 .02133 L
s
.02381 .00543 m
.02756 .00543 L
s
.02381 .6095 m
.02756 .6095 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .51412 m
.06244 .53422 L
.10458 .55498 L
.14415 .57232 L
.18221 .5861 L
.20342 .59225 L
.22272 .59677 L
.23233 .5986 L
.24276 .60027 L
.25261 .60152 L
.26171 .60239 L
.26637 .60273 L
.26894 .60288 L
.27138 .60301 L
.27364 .6031 L
.27611 .60319 L
.27835 .60325 L
.27944 .60327 L
.28044 .60329 L
.28173 .6033 L
.28241 .60331 L
.28313 .60332 L
.28434 .60332 L
.28503 .60332 L
.28567 .60332 L
.28687 .60331 L
.28796 .6033 L
.28922 .60328 L
.29042 .60326 L
.29307 .60319 L
.29552 .6031 L
.30106 .60283 L
.30569 .60251 L
.31069 .60208 L
.31973 .60106 L
.33047 .59944 L
.34033 .59756 L
.35925 .59289 L
.37995 .58616 L
.42051 .56805 L
.45956 .54452 L
.50106 .51325 L
.54104 .47752 L
.5795 .43858 L
.62042 .39309 L
.65983 .34632 L
.69771 .29965 L
.73805 .24933 L
.77688 .20155 L
.81815 .15292 L
Mistroke
.85791 .10961 L
.89616 .07253 L
.93686 .03937 L
.97604 .01479 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0001/000?o0000o`0300006`02ool0100001/000?o0000o`0300006`000ol0003o00<0
000K0003o`000?T00_l700006`000ol0003g00;o2@0001/00_og0003o`0000T0000K0003o`000?@0
0_l<00004`03o`D000?o0000lP02o`h0000F0003o`00008000?o0000l@000ol0000>00003@05o`@0
00?o00000P02oo000_lA00005002o`D000?o0000kP000ol0000A00005P000ol000020003o`000>d0
00?o00004P0001<00ol50003o`000>`000?o00004`0001/00_o[00;o5P0001/000?o0000j@000ol0
000F00006`000ol0003X0003o`0001L0000K0003o`000>L000?o0000600001/00_oW0003o`0001T0
000K0003o`000>D000?o00006P0001/000?o0000i0000ol0000K00006`000ol0003S0003o`0001`0
000K00;oh`000ol0000M00006`000ol0003Q0003o`0001h0000K0003o`000>0000?o00007`0001/0
00?o0000g`000ol0000P00006`000ol0003N0003o`000240000K00;ogP000ol0000R00006`000ol0
003L0003o`0002<0000700Co0`02o`<00ol50003o`000=/000?o0000900000P000?o00000`02o`H0
00?o00000P000ol0003K0003o`0002@000000`3oo`03o`<000?o00002P000ol0000200;of`000ol0
000U00002P000ol0000600?o1@000ol0003I0003o`0002H000070004o`00o`P000?o00001@000ol0
003H0003o`0002L0000800;o2@04o`@000?o0000e`000ol0000X00006`02omL000?o0000:@0001/0
00?o0000e@000ol0000Z00006`000ol0003D0003o`0002/0000K0003o`000=<000?o0000;00001/0
0_oC0003o`0002d0000K0003o`000=4000?o0000;P0001/000?o0000d0000ol0000_00006`000ol0
003@0003o`0002l0000K0003o`000<l000?o0000<00001/00_o?0003o`000340000K0003o`000<d0
00?o0000<P0001/000?o0000c0000ol0000c00006`000ol0003;0003o`0003@0000K00;ob`000ol0
000e00006`000ol000390003o`0003H0000C00Co10000ol000380003o`0003L0000D0003o`0000@0
00?o0000a`000ol0000h00003@05o`<000?o00000`02olL000?o0000>@0001H000?o00000P000ol0
00350003o`0003X0000C0004o`00o`@000?o0000a@000ol0000j00005002o`D000?o0000a0000ol0
000k00006`02ol@000?o0000?00001/000?o0000`P000ol0000m00006`000ol000320003o`0003d0
000K0003o`000<4000?o0000?P0001/00_o10003o`0003l0000K0003o`000;l000?o0000@00001/0
00?o0000_P000ol0001100006`000ol0002n0003o`000440000K0003o`000;d000?o0000@P0001/0
0_nm0003o`0004<0000K0003o`000;/000?o0000A00001/000?o0000^`000ol0001400006`000ol0
002j0003o`0004D0000K00;o^P000ol0001600006`000ol0002h0003o`0004L0000700?o1002o`<0
0ol50003o`000;L000?o0000B00000P000?o00000`02o`H000?o00000P000ol0002g0003o`0004P0
00000`3oo`03o`8000?o00002`000ol0000200;o]`000ol00019000020000ol0000800?o1@000ol0
002e0003o`0004X000080003o`0000P000?o00001@000ol0002d0003o`0004/0000700;o2P04o`@0
00?o0000]0000ol0001;00006`02ok@000?o0000C00001/000?o0000/P000ol0001=00006`000ol0
002a0003o`0004h0000K0003o`000;0000?o0000C`0001/000?o0000/0000ol0001?00006`02ok00
00?o0000D00001/000?o0000[P000ol0001A00006`000ol0002]0003o`000580000K0003o`000:`0
00?o0000D`0001/00_n/0003o`0005@0000K0003o`000:/000?o0000E00001/000?o0000ZP000ol0
001E00006`000ol0002Y0003o`0005H0000K00;oZ@000ol0001G00006`000ol0002W0003o`0005P0
000C00?o1@000ol0002V0003o`0005T0000D0003o`0000@000?o0000YP000ol0001I00003@05o`80
00?o00001002ojH000?o0000FP0001@000?o000010000ol0002T0003o`0005/0000D0003o`0000@0
00?o0000X`000ol0001L00004`02o`H000?o0000XP000ol0001M00006`000ol0002Q0003o`0005h0
000K00;oXP000ol0001N00006`000ol0002P0003o`0005l0000K0003o`0009l000?o0000H00001/0
00?o0000WP000ol0001Q00006`02oih000?o0000HP0001/000?o0000W0000ol0001S00006`000ol0
002L0003o`0006<0000K0003o`0009/000?o0000I00001/00_nK0003o`0006D0000K0003o`0009T0
00?o0000IP0001/000?o0000V0000ol0001W00006`000ol0002G0003o`0006P0000K00;oU`000ol0
001Y00006`000ol0002E0003o`0006X0000800;o1002o`<00ol50003o`0009@000?o0000J`0000L0
00Co003o0`02o`H000?o00000P000ol0002C0003o`0006`000000`3oo`03o`050?l00?l02`000ol0
000200;oT`000ol0001]00001`001?l00?l800?o1@000ol0002A0003o`0006h000070004o`00o`P0
00?o00001@000ol0002@0003o`0006l0000800;o2@04o`@000?o0000S`000ol0001`00006`000ol0
002>0003o`000740000K00;oSP000ol0001b00006`000ol0002<0003o`0007<0000K0003o`0008/0
00?o0000M00001/000?o0000RP000ol0001e00006`02ohX000?o0000MP0001/000?o0000R0000ol0
001g00006`000ol0000N00;o1002o`<00olO00?o8003o`@00_l300?o2P000ol0000B00Co7P04o`<0
0_l300?o8003oa80000K0003o`0001d000Co003o0`02o`H000?o00007@000ol0000P0003o`0000<0
0_l60003o`0000D00_lF0003o`0001l000?o00000`02o`H000?o000080000ol0000?00006`02oah0
00Co003o2`000ol0000M0003o`00020000?o00002`000ol000040003o`0001L000?o00007`000ol0
000:0003o`00020000?o00003`0001/000?o00007@001?l00?l800?o80000ol0000P0003o`0000P0
0ol60003o`0001T000?o00007`000ol0000600?o8@02oa80000K0003o`0001d000Co003o20000ol0
000P0003o`00020000?o000020000ol000050003o`0001L000Co003o7P001?l00?l80003o`0002<0
00?o00003`0001/000?o00007P02o`T01?lN00;o8@02o`X01?l30003o`0001T00_lP00;o2@04oal0
0olB00006`02oh4000?o0000O`0001/000?o0000O`000ol0002000006`000ol0001n0003o`000840
000K0003o`0007d000?o0000PP0001/000?o0000N`02ohD0000D0?oo3Ol001/000Co0?oo10000ol0
00050003o`0000D000?o00001@000ol000050003o`0000D000?o00001@000ol000050003o`0000D0
00?o00001@000ol000060003o`0000D000?o00001@000ol000050003o`0000D000Co003o10000ol0
00050003o`0000D000?o00001@000ol000050003o`0000D000?o00001@000ol000050003o`0000D0
00?o00001@000ol000050003o`0000H000?o00001@000ol000050003o`0000D000?o00001@000ol0
0005007o0@0100006`001?l00002ogD000?o0000Q`0001/000?o00000`02og400_n:00006`02o`H0
0_m^0003o`0008X0000K0003o`0000L00_m[0003o`0008/0000K0003o`0000T00_mX0003o`0008`0
000K0003o`0000/00omT0003o`0008d0000K00;o3`02of000_n@00006`000ol0000@00;oG002oi80
000K0003o`0001800_mH00;oU00001/000?o00005002oeD000?o0000U00001/00_lG00?oD002oiL0
000K0003o`0001T00_m<00;oV@0001/000?o00006`02odP00_nK00006`000ol0000M00;oA002oid0
000K0003o`0001l00olo00;oW`0001/00_lS00;o>`02oj40000K0003o`0002@00olf00;oX`0000P0
0_l400;o0`03o`D000?o00009`04oc000_nU00001`001?l00?l300;o1P000ol000020003o`0002/0
1?lY00?oY`0000L000Co003o2`000ol0000200;o<003ob801?nZ00001`001?l00?l800?o1@000ol0
000b00Go5P07ojh000070004o`00o`P000?o00001@000ol0000g01Ko]@0000P00_l900Co10000ol0
003o00<0000K00;oo`0400006`000ol0003o00<0000K0003o`000?l00`000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.338866, -3.3824, 
  0.0124008, 0.0236484}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Directly\ by\ Mma\ \ *) \n
    intx = Integrate[g[s], \ {s, \ 0, \[Pi]}] // N\)\)], "Input"],

Cell[BoxData[
    \(\(-2.`\)\ x\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ By\ rectangular\ rule\ n = 2\ *) \n
    int = \((\[Pi]/2)\)*\((g[\[Pi]/2] + g[\[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)\)], "Input"],

Cell[BoxData[
    \(2.5249089102843345`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Rectangular\ rule, \ n = 4\ *) \n
    int = \((\[Pi]/4)\)*
          \((\ g[0.25\ \[Pi]] + g[0.5\ \[Pi]] + g[0.75\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(1.15263977664085226`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 10*) \n
    int = \((\[Pi]/10)\)*
          \((g[0.1\ \[Pi]] + g[0.2\ \[Pi]] + g[0.3\ \[Pi]] + g[0.4\ \[Pi]] + 
              g[0.5\ \[Pi]] + g[0.6\ \[Pi]] + g[0.7\ \[Pi]] + g[0.8\ \[Pi]] + 
              g[0.9\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.438779640520951286`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 20*) \n
    int = \((\[Pi]/20)\)*
          \((g[0.05\ \[Pi]] + g[0.1\ \[Pi]] + g[0.15\ \[Pi]] + 
              g[0.2\ \[Pi]] + g[0.25\ \[Pi]] + g[0.3\ \[Pi]] + 
              g[0.35\ \[Pi]] + g[0.4\ \[Pi]] + g[0.45\ \[Pi]] + 
              g[0.5\ \[Pi]] + g[0.55\ \[Pi]] + g[0.6\ \[Pi]] + 
              g[0.65\ \[Pi]] + g[0.7\ \[Pi]] + g[0.75\ \[Pi]] + 
              g[0.8\ \[Pi]] + g[0.85\ \[Pi]] + g[0.9\ \[Pi]] + 
              g[0.95\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.215821153576078517`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 40*) \n
    int = \((\[Pi]/40)\)*
          \((g[0.025\ \[Pi]] + g[0.05\ \[Pi]] + g[0.075\ \[Pi]] + 
              g[0.1\ \[Pi]] + g[0.125\ \[Pi]] + g[0.15\ \[Pi]] + 
              g[0.175\ \[Pi]] + g[0.2\ \[Pi]] + g[0.225\ \[Pi]] + 
              g[0.25\ \[Pi]] + g[0.275\ \[Pi]] + g[0.3\ \[Pi]] + 
              g[0.325\ \[Pi]] + g[0.35\ \[Pi]] + g[0.375\ \[Pi]] + 
              g[0.4\ \[Pi]] + g[0.425\ \[Pi]] + g[0.45\ \[Pi]] + 
              g[0.475\ \[Pi]] + g[0.5\ \[Pi]] + g[0.525\ \[Pi]] + 
              g[0.55\ \[Pi]] + g[0.575\ \[Pi]] + g[0.6\ \[Pi]] + 
              g[0.625\ \[Pi]] + g[0.65\ \[Pi]] + g[0.675\ \[Pi]] + 
              g[0.7\ \[Pi]] + g[0.725\ \[Pi]] + g[0.75\ \[Pi]] + 
              g[0.775\ \[Pi]] + g[0.8\ \[Pi]] + g[0.825\ \[Pi]] + 
              g[0.85\ \[Pi]] + g[0.875\ \[Pi]] + g[0.9\ \[Pi]] + 
              g[0.925\ \[Pi]] + g[0.95\ \[Pi]] + g[0.975\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.107024170094242765`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/10)\)*
          \((\ g[0] + 2*g[0.2\ \[Pi]] + 2*g[0.4\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.057742822118837811`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 10\ *) \n
    int = \((\[Pi]/20)\)*
          \((\ g[0] + 2*g[0.1\ \[Pi]] + 2*g[0.2\ \[Pi]] + 2*g[0.3\ \[Pi]] + 
              2*g[0.4\ \[Pi]] + 2*g[0.5\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.7\ \[Pi]] + 2*g[0.8\ \[Pi]] + 2*g[0.9\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.014222031686750256`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 20\ *) \n
    int = \((\[Pi]/40)\)*
          \((\ g[0] + 2*g[0.05\ \[Pi]] + 2*g[0.1\ \[Pi]] + 2*g[0.15\ \[Pi]] + 
              2*g[0.2\ \[Pi]] + 2*g[0.25\ \[Pi]] + 2*g[0.3\ \[Pi]] + 
              2*g[0.35\ \[Pi]] + 2*g[0.4\ \[Pi]] + 2*g[0.45\ \[Pi]] + 
              2*g[0.5\ \[Pi]] + 2*g[0.55\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.65\ \[Pi]] + 2*g[0.7\ \[Pi]] + 2*g[0.75\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + 2*g[0.85\ \[Pi]] + 2*g[0.9\ \[Pi]] + 
              2*g[0.95\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.00354234915897803226`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 40\ *) \n
    int = \((\[Pi]/80)\)*
          \((\ g[0] + 2*g[0.025\ \[Pi]] + 2*g[0.05\ \[Pi]] + 
              2*g[0.075\ \[Pi]] + \n\t\t\t\ \ \ \ \ \ 2*g[0.1\ \[Pi]] + 
              2*g[0.125\ \[Pi]] + 2*g[0.15\ \[Pi]] + 2*g[0.175\ \[Pi]] + 
              2*g[0.2\ \[Pi]] + 2*g[0.225\ \[Pi]] + 2*g[0.25\ \[Pi]] + 
              2*g[0.275\ \[Pi]] + 2*g[0.3\ \[Pi]] + 2*g[0.325\ \[Pi]] + 
              2*g[0.35\ \[Pi]] + 2*g[0.375\ \[Pi]] + 2*g[0.4\ \[Pi]] + 
              2*g[0.425\ \[Pi]] + 2*g[0.45\ \[Pi]] + 2*g[0.475\ \[Pi]] + 
              2*g[0.5\ \[Pi]] + 2*g[0.525\ \[Pi]] + 2*g[0.55\ \[Pi]] + 
              2*g[0.575\ \[Pi]] + 2*g[0.6\ \[Pi]] + 2*g[0.625\ \[Pi]] + 
              2*g[0.65\ \[Pi]] + 2*g[0.675\ \[Pi]] + 2*g[0.7\ \[Pi]] + 
              2*g[0.725\ \[Pi]] + 2*g[0.75\ \[Pi]] + 2*g[0.775\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + 2*g[0.825\ \[Pi]] + 2*g[0.85\ \[Pi]] + 
              2*g[0.875\ \[Pi]] + 2*g[0.9\ \[Pi]] + 2*g[0.925\ \[Pi]] + 
              2*g[0.95\ \[Pi]] + 2*g[0.975\ \[Pi]] + g[\[Pi]])\) // Simplify; 
    \neQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.000884767885692330402`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/15)\)*
          \((\ g[0] + 4*g[0.25\ \[Pi]] + 2*g[0.5\ \[Pi]] + 4*g[0.75\ \[Pi]] + 
              g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.354036861716049688`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 7\ *) \n
    int = \(\((\[Pi]/21)\)*
            \((\ g[0] + 4*g[\[Pi]/6] + 2*g[\[Pi]/3] + 4*g[\[Pi]/2] + \n
                \t\t\t\t2*g[2\ \[Pi]/3] + 4*g[5\ \[Pi]/6] + g[\[Pi]])\) // 
          Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.247761834470386599`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 9*) \n
    int = \(\((\[Pi]/27)\)*
            \((\ g[0] + 4*g[\[Pi]/8] + 2*g[\[Pi]/4] + 4*g[3\ \[Pi]/8] + \n
                \t\t\t\t2*g[\[Pi]/2] + 4*g[5\ \[Pi]/8] + 2*g[3\ \[Pi]/4] + 
                4*g[7\ \[Pi]/8] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.191810443574600455`\[InvisibleSpace]\) - 
      2.35676816303765335`*^-16\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Abs[%]\n\)\)], "Input"],

Cell[BoxData[
    \(0.191810443574600455`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 11*) \n
    int = \(\((\[Pi]/33)\)*
            \((\ g[0] + 4*g[\[Pi]/10] + 2*g[\[Pi]/5] + 4*g[3\ \[Pi]/10] + \n
                \t\t\t\t2*g[2\ \[Pi]/5] + 4*g[\[Pi]/2] + 2*g[3\ \[Pi]/5] + 
                4*g[7\ \[Pi]/10] + 2*g[4\ \[Pi]/5] + 4*g[9\ \[Pi]/10] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((int - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.15668328751186018`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 17*) \n
    int = \(\((\[Pi]/51)\)*
            \((\ g[0] + 4*g[\[Pi]/16] + 2*g[2\ \[Pi]/16] + 4*g[3\ \[Pi]/16] + 
                \n\t\t\t\t2*g[4\ \[Pi]/16] + 4*g[5\ \[Pi]/16] + 
                2*g[6\ \[Pi]/16] + 4*g[7\ \[Pi]/16] + 2*g[8\ \[Pi]/16] + 
                4*g[9\ \[Pi]/16] + 2*g[10\ \[Pi]/16] + 4*g[11\ \[Pi]/16] + 
                2*g[12\ \[Pi]/16] + 4*g[13\ \[Pi]/16] + 2*g[14\ \[Pi]/16] + 
                4*g[15\ \[Pi]/16] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.101256142702422113`\[InvisibleSpace]\) - 
      1.17838408151882667`*^-16\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.101256142702422113`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\tClear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 33*) \n
    int = \(\((\[Pi]/99)\)*
            \((\ g[0] + 4*g[\[Pi]/32] + 2*g[2\ \[Pi]/32] + 4*g[3\ \[Pi]/32] + 
                \n\t\t\t\t2*g[4\ \[Pi]/32] + 4*g[5\ \[Pi]/32] + 
                2*g[6\ \[Pi]/32] + 4*g[7\ \[Pi]/32] + 2*g[8\ \[Pi]/32] + 
                4*g[9\ \[Pi]/32] + 2*g[10\ \[Pi]/32] + 4*g[11\ \[Pi]/32] + 
                2*g[12\ \[Pi]/32] + 4*g[13\ \[Pi]/32] + 2*g[14\ \[Pi]/32] + 
                4*g[15\ \[Pi]/32] + 2*g[16\ \[Pi]/32] + 4*g[17\ \[Pi]/32] + 
                2*g[18\ \[Pi]/32] + 4*g[19\ \[Pi]/32] + 2*g[20\ \[Pi]/32] + 
                4*g[21\ \[Pi]/32] + 2*g[22\ \[Pi]/32] + 4*g[23\ \[Pi]/32] + 
                2*g[24\ \[Pi]/32] + 4*g[25\ \[Pi]/32] + 2*g[26\ \[Pi]/32] + 
                4*g[27\ \[Pi]/32] + 2*g[28\ \[Pi]/32] + 4*g[29\ \[Pi]/32] + 
                4*g[30\ \[Pi]/32] + 4*g[31\ \[Pi]/32] + g[\[Pi]])\) // 
          Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)\)], "Input"],

Cell[BoxData[
    \(\(0.105583199284058371`\[InvisibleSpace]\) - 
      2.35676816303765335`*^-16\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.105583199284058371`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/5)\)*\ 
          \((g[0.1\ \[Pi]] + g[0.3\ \[Pi]] + g[0.5\ \[Pi]] + g[0.7\ \[Pi]] + 
              g[0.9\ \[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.0292987587453374942`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 10\ *) \n
    int = \(\((\[Pi]/10)\)*\ 
            \((g[\[Pi]/20] + g[3\ \[Pi]/20] + g[5\ \[Pi]/20] + 
                g[7\ \[Pi]/20] + g[9\ \[Pi]/20] + g[11\ \[Pi]/20] + 
                g[13\ \[Pi]/20] + g[15\ \[Pi]/20] + g[17\ \[Pi]/20] + 
                g[19\ \[Pi]/20])\) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.00713733336879266211`\[InvisibleSpace]\) + 
      2.65136418341736002`*^-16\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.00713733336879266211`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 20\ *) \n
    int = \(\((\[Pi]/20)\)*\ 
            \((g[\[Pi]/40] + g[3\ \[Pi]/40] + g[5\ \[Pi]/40] + 
                g[7\ \[Pi]/40] + g[9\ \[Pi]/40] + g[11\ \[Pi]/40] + 
                g[13\ \[Pi]/40] + g[15\ \[Pi]/40] + g[17\ \[Pi]/40] + 
                g[19\ \[Pi]/40] + g[21\ \[Pi]/40] + g[23\ \[Pi]/40] + 
                g[25\ \[Pi]/40] + g[27\ \[Pi]/40] + g[29\ \[Pi]/40] + 
                g[31\ \[Pi]/40] + g[33\ \[Pi]/40] + g[35\ \[Pi]/40] + 
                g[37\ \[Pi]/40] + g[39\ \[Pi]/40])\) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.00177281338759069679`\[InvisibleSpace]\) + 
      2.94596020379706668`*^-16\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.00177281338759069679`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 7\ *) \n
    int = \(\((3\ \[Pi]/70)\)*
            \((g[0] + 5*g[\[Pi]/7] + g[2\ \[Pi]/7] + 6*g[3\ \[Pi]/7] + 
                g[4\ \[Pi]/7] + 5*g[5\ \[Pi]/7] + 2*g[6\ \[Pi]/7] + g[\[Pi]])
              \) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.445343544585215855`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \nClear[int, \[CurlyPhi]]; 
    \n (*\ Weddle\ Rule\ n = 13\ *) \n
    int = \(\((3\ \[Pi]/130)\)*
            \((g[0] + 5*g[\[Pi]/13] + g[2\ \[Pi]/13] + 6*g[3\ \[Pi]/13] + 
                g[4\ \[Pi]/13] + 5*g[5\ \[Pi]/13] + 2*g[6\ \[Pi]/13] + 
                5*g[7\ \[Pi]/13] + g[8\ \[Pi]/13] + 6*g[9\ \[Pi]/13] + 
                g[10\ \[Pi]/13] + 5*g[11\ \[Pi]/13] + 2*g[12\ \[Pi]/13] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.250497898827131226`\[InvisibleSpace]\) + 
      1.0016264692910024`*^-15\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.250497898827131226`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 19\ *) \n
    int = \(\((3\ \[Pi]/190)\)*
            \((g[0] + 5*g[\[Pi]/19] + g[2\ \[Pi]/19] + 6*g[3\ \[Pi]/19] + 
                g[4\ \[Pi]/19] + 5*g[5\ \[Pi]/19] + 2*g[6\ \[Pi]/19] + 
                5*g[7\ \[Pi]/19] + g[8\ \[Pi]/19] + 6*g[9\ \[Pi]/19] + 
                g[10\ \[Pi]/19] + 5*g[11\ \[Pi]/19] + 2*g[12\ \[Pi]/19] + \n
                \t\t\t\t5*g[13\ \[Pi]/19] + g[14\ \[Pi]/19] + 
                6*g[15\ \[Pi]/19] + g[16\ \[Pi]/19] + 5*g[17  \[Pi]/19] + 
                2*g[18\ \[Pi]/19] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.173835633301224046`\[InvisibleSpace]\) + 
      9.13247663177090629`*^-16\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.173835633301224046`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 25\ *) \n
    int = \(\((3\ \[Pi]/250)\)*
            \((g[0] + 5*g[\[Pi]/25] + g[2\ \[Pi]/25] + 6*g[3\ \[Pi]/25] + 
                g[4\ \[Pi]/25] + 5*g[5\ \[Pi]/25] + 2*g[6\ \[Pi]/25] + 
                5*g[7\ \[Pi]/25] + g[8\ \[Pi]/25] + 6*g[9\ \[Pi]/25] + 
                g[10\ \[Pi]/25] + 5*g[11\ \[Pi]/25] + 2*g[12\ \[Pi]/25] + \n
                \t\t\t\t5*g[13\ \[Pi]/25] + g[14\ \[Pi]/25] + 
                6*g[15\ \[Pi]/25] + g[16\ \[Pi]/25] + 5*g[17\ \[Pi]/25] + 
                2*g[18\ \[Pi]/25] + \n\t\t\t\t5*g[19\ \[Pi]/25] + 
                g[20\ \[Pi]/25] + 6*g[21\ \[Pi]/25] + g[22\ \[Pi]/25] + 
                5*g[23\ \[Pi]/25] + 2*g[24\ \[Pi]/25] + g[\[Pi]])\) // 
          Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.133046135566774959`\[InvisibleSpace]\) + 
      2.94596020379706668`*^-17\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.133046135566774959`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 31\ *) \n
    int = \(\((3\ \[Pi]/310)\)*
            \((g[0] + 5*g[\[Pi]/31] + g[2\ \[Pi]/31] + 6*g[3\ \[Pi]/31] + 
                g[4\ \[Pi]/31] + 5*g[5\ \[Pi]/31] + 2*g[6\ \[Pi]/31] + 
                5*g[7\ \[Pi]/31] + g[8\ \[Pi]/31] + 6*g[9\ \[Pi]/31] + 
                g[10\ \[Pi]/31] + 5*g[11\ \[Pi]/31] + 2*g[12\ \[Pi]/31] + \n
                \t\t\t\t5*g[13\ \[Pi]/31] + g[14\ \[Pi]/31] + 
                6*g[15\ \[Pi]/31] + g[16\ \[Pi]/31] + 5*g[17\ \[Pi]/31] + 
                2*g[18\ \[Pi]/31] + \n\t\t\t\t5*g[19\ \[Pi]/31] + 
                g[20\ \[Pi]/31] + 6*g[21\ \[Pi]/31] + g[22\ \[Pi]/31] + 
                5*g[23\ \[Pi]/31] + 2*g[24\ \[Pi]/31] + 5*g[25\ \[Pi]/31] + 
                g[26\ \[Pi]/31] + 6*g[27\ \[Pi]/31] + g[28\ \[Pi]/31] + 
                5*g[29\ \[Pi]/31] + 2*g[30\ \[Pi]/31] + g[\[Pi]])\) // 
          Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.107746824844286104`\[InvisibleSpace]\) - 
      1.47298010189853334`*^-16\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.107746824844286104`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 37*) \n
    int = \(\((3\ \[Pi]/370)\)*
            \((g[0] + 5*g[\[Pi]/37] + g[2\ \[Pi]/37] + 6*g[3\ \[Pi]/37] + 
                g[4\ \[Pi]/37] + 5*g[5\ \[Pi]/37] + 2*g[6\ \[Pi]/37] + 
                5*g[7\ \[Pi]/37] + g[8\ \[Pi]/37] + 6*g[9\ \[Pi]/37] + 
                g[10\ \[Pi]/37] + 5*g[11\ \[Pi]/37] + 2*g[12\ \[Pi]/37] + \n
                \t\t\t\t5*g[13\ \[Pi]/37] + g[14\ \[Pi]/37] + 
                6*g[15\ \[Pi]/37] + g[16\ \[Pi]/37] + 5*g[17\ \[Pi]/37] + 
                2*g[18\ \[Pi]/37] + \n\t\t\t\t5*g[19\ \[Pi]/37] + 
                g[20\ \[Pi]/37] + 6*g[21\ \[Pi]/37] + g[22\ \[Pi]/37] + 
                5*g[23\ \[Pi]/37] + 2*g[24\ \[Pi]/37] + 5*g[25\ \[Pi]/37] + 
                g[26\ \[Pi]/37] + 6*g[27\ \[Pi]/37] + g[28\ \[Pi]/37] + 
                5*g[29\ \[Pi]/37] + 2*g[30\ \[Pi]/37] + \n\t\t\t\t\t\t\t
                5*g[31\ \[Pi]/37] + g[32\ \[Pi]/37] + 6*g[33\ \[Pi]/37] + 
                g[34\ \[Pi]/37] + 5*g[35\ \[Pi]/37] + 2*g[36\ \[Pi]/37] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.0905270056506394737`\[InvisibleSpace]\) + 
      2.65136418341736002`*^-16\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.0905270056506394737`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 43*) \n
    int = \(\((3\ \[Pi]/430)\)*
            \((g[0] + 5*g[\[Pi]/43] + g[2\ \[Pi]/43] + 6*g[3\ \[Pi]/43] + 
                g[4\ \[Pi]/43] + 5*g[5\ \[Pi]/43] + 2*g[6\ \[Pi]/43] + 
                5*g[7\ \[Pi]/43] + g[8\ \[Pi]/43] + 6*g[9\ \[Pi]/43] + 
                g[10\ \[Pi]/43] + 5*g[11\ \[Pi]/43] + 2*g[12\ \[Pi]/43] + \n
                \t\t\t\t5*g[13\ \[Pi]/43] + g[14\ \[Pi]/43] + 
                6*g[15\ \[Pi]/43] + g[16\ \[Pi]/43] + 5*g[17\ \[Pi]/43] + 
                2*g[18\ \[Pi]/43] + \n\t\t\t\t5*g[19\ \[Pi]/43] + 
                g[20\ \[Pi]/43] + 6*g[21\ \[Pi]/43] + g[22\ \[Pi]/43] + 
                5*g[23\ \[Pi]/43] + 2*g[24\ \[Pi]/43] + 5*g[25\ \[Pi]/43] + 
                g[26\ \[Pi]/43] + 6*g[27\ \[Pi]/43] + g[28\ \[Pi]/43] + 
                5*g[29\ \[Pi]/43] + 2*g[30\ \[Pi]/43] + \n\t\t\t\t\t\t\t
                5*g[31\ \[Pi]/43] + g[32\ \[Pi]/43] + 6*g[33\ \[Pi]/43] + 
                g[34\ \[Pi]/43] + 5*g[35\ \[Pi]/43] + 2*g[36\ \[Pi]/43] + 
                5*g[37\ \[Pi]/43] + g[38\ \[Pi]/43] + 6*g[39\ \[Pi]/43] + 
                g[40\ \[Pi]/43] + 5*g[41\ \[Pi]/43] + 2*g[42\ \[Pi]/43] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(\(0.0780507986316657742`\[InvisibleSpace]\) + 
      2.07690194367693248`*^-15\ I\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[%]\)], "Input"],

Cell[BoxData[
    \(0.0780507986316657742`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Gauss - Legendre\ rule\ n = 2*) \n
    int = 0.5\ \[Pi]*
          \((g[0.663896644677787772`] + g[2.47769600891200525`])\) // 
        Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.209878725377153418`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Gauss - Legendre\ Rule\ n = 4\ *) \n
    int = \ \[Pi]\ *
          \((0.1739274226*g[0.218126571673253266`] + 
              0.3260725774*g[1.03675535235190863`] + 
              0.3260725774*g[2.10483730123788426`] + 
              0.1739274226*g[2.92346608191653967`])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(0.000106888953111109952`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 4\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/4)\)*
          \((g[0.0380602337443566263`]\  + \n\t\t\t\t
              g[0.308658283817455281`] + g[0.691341716182543475`] + 
              g[0.961939766255644812`])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(2.02498224389562908`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 6\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/6)\)*
          \((g[0.0170370868554658567`]\  + \n\t\t\t\t
              g[0.146446609406726224`] + g[0.370590477448738297`] + 
              g[0.62940952255127458`] + g[0.853553390593233451`] + 
              g[0.982962913144561944`])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(2.02498224665529136`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 8\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/8)\)*
          \((g[0.00960735979838477582`]\  + \n\t\t\t\t
              g[0.0842651938487273355`] + g[0.222214883490200598`] + 
              g[0.402454838991917007`] + g[0.597545161008159819`] + 
              g[0.777785116509540586`] + g[0.915734806151648328`] + 
              g[0.990392640201421059`])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(2.02498224665529358`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Newton - Cotes\ rule\ n = 4\ *) \n
    int = \(\((7*g[0] + 32*g[0.25] + 12*g[0.5] + 32*g[0.75] + 7*g[1])\)/90 // 
          N\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(2.04911810638071711`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Newton - Cotes\ rule\ n = 5\ *) \n
    int = \(\((
              19*g[0] + 75*g[0.2] + 50*g[0.4] + 50*g[0.6] + 75*g[0.8] + 
                19*g[1])\)/288 // N\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 0.860333589028837764`\)], "Input"],

Cell[BoxData[
    \(2.04911874387072323`\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{Automatic, 70}, {Automatic, 14}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 154, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[1896, 55, 144, 2, 59, "Input"],
Cell[2043, 59, 67, 1, 26, "Output"],
Cell[2113, 62, 12107, 448, 186, 5028, 356, "GraphicsData", "PostScript", \
"Graphics"],
Cell[14223, 512, 130, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14390, 520, 119, 2, 43, "Input"],
Cell[14512, 524, 45, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14594, 530, 207, 3, 59, "Input"],
Cell[14804, 535, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14894, 541, 278, 5, 91, "Input"],
Cell[15175, 548, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15266, 554, 389, 6, 123, "Input"],
Cell[15658, 562, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15750, 568, 619, 10, 155, "Input"],
Cell[16372, 580, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16464, 586, 1082, 17, 235, "Input"],
Cell[17549, 605, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17641, 611, 308, 5, 91, "Input"],
Cell[17952, 618, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18044, 624, 427, 7, 123, "Input"],
Cell[18474, 633, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18566, 639, 664, 10, 171, "Input"],
Cell[19233, 651, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19327, 657, 1189, 17, 299, "Input"],
Cell[20519, 676, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20614, 682, 295, 5, 107, "Input"],
Cell[20912, 689, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21004, 695, 354, 6, 91, "Input"],
Cell[21361, 703, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21453, 709, 394, 6, 123, "Input"],
Cell[21850, 717, 114, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22001, 724, 45, 1, 43, "Input"],
Cell[22049, 727, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22141, 733, 450, 7, 123, "Input"],
Cell[22594, 742, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22685, 748, 617, 9, 171, "Input"],
Cell[23305, 759, 114, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23456, 766, 39, 1, 27, "Input"],
Cell[23498, 769, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23590, 775, 1039, 15, 267, "Input"],
Cell[24632, 792, 114, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24783, 799, 39, 1, 27, "Input"],
Cell[24825, 802, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24917, 808, 296, 5, 107, "Input"],
Cell[25216, 815, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25309, 821, 437, 7, 123, "Input"],
Cell[25749, 830, 116, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25902, 837, 39, 1, 27, "Input"],
Cell[25944, 840, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26038, 846, 668, 10, 171, "Input"],
Cell[26709, 858, 116, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26862, 865, 39, 1, 27, "Input"],
Cell[26904, 868, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26998, 874, 361, 6, 107, "Input"],
Cell[27362, 882, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27454, 888, 550, 9, 171, "Input"],
Cell[28007, 899, 113, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28157, 906, 39, 1, 27, "Input"],
Cell[28199, 909, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28291, 915, 678, 10, 187, "Input"],
Cell[28972, 927, 114, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29123, 934, 39, 1, 27, "Input"],
Cell[29165, 937, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29257, 943, 849, 13, 219, "Input"],
Cell[30109, 958, 114, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30260, 965, 39, 1, 27, "Input"],
Cell[30302, 968, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30394, 974, 999, 15, 267, "Input"],
Cell[31396, 991, 114, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31547, 998, 39, 1, 27, "Input"],
Cell[31589, 1001, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31681, 1007, 1169, 17, 267, "Input"],
Cell[32853, 1026, 115, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33005, 1033, 39, 1, 27, "Input"],
Cell[33047, 1036, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33140, 1042, 1319, 19, 315, "Input"],
Cell[34462, 1063, 115, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34614, 1070, 39, 1, 27, "Input"],
Cell[34656, 1073, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34749, 1079, 266, 5, 91, "Input"],
Cell[35018, 1086, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35110, 1092, 403, 7, 139, "Input"],
Cell[35516, 1101, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35611, 1107, 421, 8, 155, "Input"],
Cell[36035, 1117, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36126, 1123, 489, 9, 187, "Input"],
Cell[36618, 1134, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36709, 1140, 561, 10, 219, "Input"],
Cell[37273, 1152, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37364, 1158, 261, 4, 107, "Input"],
Cell[37628, 1164, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37719, 1170, 295, 5, 107, "Input"],
Cell[38017, 1177, 54, 1, 26, "Output"]
}, Open  ]],
Cell[38086, 1181, 26, 0, 27, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

